package rs.ac.bg.fon.ai.dataPreparation;

import weka.classifiers.meta.FilteredClassifier;
import weka.classifiers.trees.J48;
import weka.core.Instances;
import weka.core.converters.ConverterUtils.DataSource;
import weka.filters.Filter;
import weka.filters.supervised.attribute.Discretize;

public class SupervisedDiscretizationExample {

	private static String fileName = "data/diabetes.arff";

	public static void main(String[] args) throws Exception {
		
		// reading dataset from file
		DataSource loader = new DataSource(fileName);
		Instances data = loader.getDataSet();
		data.setClassIndex(data.numAttributes() - 1);
		
		// creating a supervised discretization filter 
		Discretize discretizeFilter = new Discretize();
		discretizeFilter.setAttributeIndices("2");
		discretizeFilter.setInputFormat(data);
		
		Instances filteredDataset = Filter.useFilter(data, discretizeFilter);
		
		System.out.println(filteredDataset);
	}
}
