package rs.ac.bg.fon.ai.dataPreparation;

import java.util.Enumeration;

import weka.attributeSelection.BestFirst;
import weka.attributeSelection.WrapperSubsetEval;
import weka.classifiers.bayes.NaiveBayes;
import weka.core.Instances;
import weka.core.converters.ConverterUtils.DataSource;
import weka.filters.Filter;
import weka.filters.supervised.attribute.AttributeSelection;

public class AttributeSelectionExample {

	private static String fileName = "data/census90-income.arff";

	public static void main(String[] args) throws Exception {

		// reading dataset from file
		DataSource loader = new DataSource(fileName);
		Instances data = loader.getDataSet();
		data.setClassIndex(data.numAttributes() - 1);
		
		// printing all attributes from new instance set
		printAttributeLabels(data);
		
		
		// creating a classifier instance
		NaiveBayes naiveBayesClassifier = new NaiveBayes();
		naiveBayesClassifier.setUseSupervisedDiscretization(true);
		
		// creating evaluator wrapped around the classifier
		WrapperSubsetEval evaluator = new WrapperSubsetEval();
		evaluator.setClassifier(naiveBayesClassifier);
		
		// creating a filter of a type AttributeSelection and setting evaluator and search method
		AttributeSelection attributeSelectionFilter = new AttributeSelection();
		attributeSelectionFilter.setEvaluator(evaluator);
		attributeSelectionFilter.setSearch(new BestFirst());
		attributeSelectionFilter.setInputFormat(data);
		
		// applying the filter and getting new instance set as a result
		Instances outputTrain = Filter.useFilter(data, attributeSelectionFilter);
		
		// printing all attributes from new instance set
		System.out.println("----------------------------");
		System.out.println("New attributes");
		System.out.println("----------------------------");
		
		printAttributeLabels(outputTrain);
	}

	private static void printAttributeLabels(Instances dataset) {
		Enumeration<?> enumerateAttributes = dataset.enumerateAttributes();
		while (enumerateAttributes.hasMoreElements()) {
			Object object = (Object) enumerateAttributes.nextElement();
			
			System.out.println(object);
		}
	}
}
