package rs.ac.bg.fon.ai.dataPreparation;

import weka.core.Instances;
import weka.core.converters.ConverterUtils.DataSource;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.Normalize;

public class NormalizeExample {

	private static String fileName = "data/weather.numeric.arff";

	public static void main(String[] args) throws Exception {

		// reading dataset from file
		DataSource loader = new DataSource(fileName);
		Instances data = loader.getDataSet();
		data.setClassIndex(data.numAttributes() - 1);
		
		// creating a filter for normalization
		Normalize normalizeFilter = new Normalize();
		normalizeFilter.setScale(2);	// scale is usually 1, but can be overridden
		normalizeFilter.setInputFormat(data);
		
		// applying the filter and getting new instance set as a result
		Instances outputTrain = Filter.useFilter(data, normalizeFilter);
		
		System.out.println(outputTrain);
	}
}
