package rs.ac.bg.fon.ai.dataPreparation;

import java.text.DecimalFormat;
import java.util.Random;

import weka.classifiers.Evaluation;
import weka.classifiers.trees.J48;
import weka.core.Instances;
import weka.core.converters.ConverterUtils.DataSource;

public class PercentageSplit {

	private static String fileName = "data/diabetes.arff";

	public static void main(String[] args) throws Exception {
		// reading dataset from file
		DataSource loader = new DataSource(fileName);
		Instances dataset = loader.getDataSet();		// contains the full dataset we want to create train/test sets from
		dataset.setClassIndex(dataset.numAttributes() - 1);
		
		
		// Randomizing the full dataset using random generator and set seed number
		int seed = 2;		// zero value denotes that no randomizing should occur
		
		Random rand = new Random(seed);   			// create seeded number generator
		Instances randData = new Instances(dataset);   // create copy of original data
		randData.randomize(rand);         			// randomize data with number generator
		
		int trainSize = (int) Math.round(randData.numInstances() * 0.9);		// train set will consist of 90% of the full dataset
		int testSize = randData.numInstances() - trainSize;					// test set will consist of 10% of the full dataset
		Instances train = new Instances(randData, 0, trainSize);
		Instances test = new Instances(randData, trainSize, testSize);
		
		
		J48 dTreeClasf = new J48();
		dTreeClasf.buildClassifier(train);
		
		
		// evaluate the model with the test data
		Evaluation eval = new Evaluation(test);
		eval.evaluateModel(dTreeClasf, test);
		
		// printing the accuracy
		System.out.println(new DecimalFormat().format(eval.pctCorrect()));
		
		
		
		
		
	}
}
