package rs.fon.is.weka.classification;

import java.text.DecimalFormat;

import weka.classifiers.Evaluation;
import weka.classifiers.trees.J48;
import weka.core.Instances;
import weka.core.converters.ConverterUtils.DataSource;

public class WekaToPlayInputFromFile {

	private static String trainingDataFileName = "data/ToPlayOrNotToPlay.arff";
	private static String testDataFileName = "data/ToPlayOrNotToPlay-test.arff";

	public static void main(String[] args) throws Exception {

		// load training data
		Instances trainingData = loadDataset(trainingDataFileName);
		
		// create the Decision Tree Classifier
		J48 dTreeClasf = new J48();
		dTreeClasf.buildClassifier(trainingData);
		
		// print generated model
		System.out.println(dTreeClasf);
		
		// load test data
		Instances testData = loadDataset(testDataFileName);
		
		// evaluate the model with the test data
		Evaluation eval = new Evaluation(testData);
		eval.evaluateModel(dTreeClasf, testData);
	
		// Print the evaluation results
		
		// specify the class value that is considered positive 
		// in this case, it is the value "yes", the 1st value 
		int positiveClass = 0;
		// decimal number formatter for better display
		DecimalFormat formatter = new DecimalFormat();
		// - the confusion matrix
		System.out.println(eval.toMatrixString());
		// - accuracy
		System.out.println("accuracy: " + formatter.format(eval.pctCorrect()));
		// - precision
		System.out.println("precision: " + formatter.format(eval.precision(positiveClass)));
		// - recall 
		System.out.println("recall: " + formatter.format(eval.recall(positiveClass)));
		// - F measure
		System.out.println("F measure: " + formatter.format(eval.fMeasure(positiveClass)));
		
	}
	
	private static Instances loadDataset(String filePath) throws Exception {
		DataSource dataSource = new DataSource(filePath);
		Instances dataset = dataSource.getDataSet();
		dataset.setClassIndex(dataset.numAttributes()-1);
		return dataset;
	}

}
