/*
 * Decompiled with CFR 0.152.
 */
package no.uib.cipr.matrix;

import no.uib.cipr.matrix.AbstractTriangDenseMatrix;
import no.uib.cipr.matrix.Diag;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.MatrixEntry;
import no.uib.cipr.matrix.UpLo;

public class UpperTriangDenseMatrix
extends AbstractTriangDenseMatrix {
    public UpperTriangDenseMatrix(int n) {
        super(n, UpLo.Upper, Diag.NonUnit);
    }

    UpperTriangDenseMatrix(int n, Diag diag) {
        super(n, UpLo.Upper, diag);
    }

    public UpperTriangDenseMatrix(Matrix A) {
        this(A, Math.min(A.numRows(), A.numColumns()));
    }

    public UpperTriangDenseMatrix(Matrix A, boolean deep) {
        this(A, Math.min(A.numRows(), A.numColumns()), deep);
    }

    UpperTriangDenseMatrix(Matrix A, boolean deep, Diag diag) {
        this(A, Math.min(A.numRows(), A.numColumns()), deep, diag);
    }

    public UpperTriangDenseMatrix(Matrix A, int k) {
        this(A, k, true);
    }

    public UpperTriangDenseMatrix(Matrix A, int k, boolean deep) {
        super(A, k, deep, UpLo.Upper, Diag.NonUnit);
    }

    UpperTriangDenseMatrix(Matrix A, int k, boolean deep, Diag diag) {
        super(A, k, deep, UpLo.Upper, diag);
    }

    @Override
    public void add(int row, int column, double value) {
        if (row > column) {
            throw new IllegalArgumentException("row > column");
        }
        super.add(row, column, value);
    }

    @Override
    public double get(int row, int column) {
        if (row > column) {
            return 0.0;
        }
        return super.get(row, column);
    }

    @Override
    public void set(int row, int column, double value) {
        if (row > column) {
            throw new IllegalArgumentException("row > column");
        }
        super.set(row, column, value);
    }

    @Override
    void copy(Matrix A) {
        for (MatrixEntry e : A) {
            if (e.row() > e.column()) continue;
            this.set(e.row(), e.column(), e.get());
        }
    }

    @Override
    public Matrix set(Matrix A) {
        this.zero();
        this.copy(A);
        return this;
    }

    @Override
    public UpperTriangDenseMatrix copy() {
        return new UpperTriangDenseMatrix(this);
    }
}

