/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.knowledgeflow;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JToggleButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileFilter;
import weka.core.Defaults;
import weka.core.Environment;
import weka.core.Instances;
import weka.core.Memory;
import weka.core.Settings;
import weka.core.WekaException;
import weka.gui.AbstractPerspective;
import weka.gui.CloseableTabTitle;
import weka.gui.ExtensionFileFilter;
import weka.gui.GUIApplication;
import weka.gui.PerspectiveInfo;
import weka.gui.explorer.PreprocessPanel;
import weka.gui.knowledgeflow.DesignPanel;
import weka.gui.knowledgeflow.MainKFPerspectiveToolBar;
import weka.gui.knowledgeflow.StepTree;
import weka.gui.knowledgeflow.StepVisual;
import weka.gui.knowledgeflow.TemplateManager;
import weka.gui.knowledgeflow.VisibleLayout;
import weka.knowledgeflow.Flow;
import weka.knowledgeflow.JSONFlowUtils;
import weka.knowledgeflow.KFDefaults;
import weka.knowledgeflow.LoggingLevel;
import weka.knowledgeflow.StepManagerImpl;
import weka.knowledgeflow.steps.MemoryBasedDataSource;

@PerspectiveInfo(ID="knowledgeflow.main", title="Data mining processes", toolTipText="Data mining processes", iconPath="weka/gui/weka_icon_new_small.png")
public class MainKFPerspective
extends AbstractPerspective {
    public static final String FLOW_PARENT_DIRECTORY_VARIABLE_KEY = "Internal.knowledgeflow.directory";
    public static final String FILE_EXTENSION_JSON = ".kf";
    private static final long serialVersionUID = 3986047323839299447L;
    private static Memory m_memory = new Memory(true);
    protected int m_untitledCount = 1;
    protected boolean m_allowMultipleTabs = true;
    protected StepManagerImpl m_palleteSelectedStep;
    protected JTabbedPane m_flowTabs = new JTabbedPane();
    protected List<VisibleLayout> m_flowGraphs = new ArrayList<VisibleLayout>();
    protected StepTree m_stepTree;
    protected String m_pasteBuffer;
    protected JFileChooser m_FileChooser = new JFileChooser(new File(System.getProperty("user.dir")));
    protected TemplateManager m_templateManager = new TemplateManager();
    protected MainKFPerspectiveToolBar m_mainToolBar;

    public MainKFPerspective() {
        this.m_isLoaded = true;
        this.m_isActive = true;
        this.setLayout(new BorderLayout());
        this.m_stepTree = new StepTree(this);
        DesignPanel designPanel = new DesignPanel(this.m_stepTree);
        JSplitPane pane = new JSplitPane(1, designPanel, this.m_flowTabs);
        pane.setOneTouchExpandable(true);
        this.add((Component)pane, "Center");
        Dimension d = designPanel.getPreferredSize();
        d = new Dimension((int)(d.getWidth() * 1.5), (int)d.getHeight());
        designPanel.setPreferredSize(d);
        designPanel.setMinimumSize(d);
        this.m_flowTabs.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                int selected = MainKFPerspective.this.m_flowTabs.getSelectedIndex();
                MainKFPerspective.this.setActiveTab(selected);
            }
        });
        this.m_mainToolBar = new MainKFPerspectiveToolBar(this);
        this.add((Component)this.m_mainToolBar, "North");
        FileFilter nativeF = null;
        for (FileFilter f : Flow.FLOW_FILE_EXTENSIONS) {
            this.m_FileChooser.addChoosableFileFilter(f);
            if (!((ExtensionFileFilter)f).getExtensions()[0].equals(FILE_EXTENSION_JSON)) continue;
            nativeF = f;
        }
        if (nativeF != null) {
            this.m_FileChooser.setFileFilter(nativeF);
        }
    }

    public StepManagerImpl getPalleteSelectedStep() {
        return this.m_palleteSelectedStep;
    }

    protected void setPalleteSelectedStep(StepManagerImpl stepvisual) {
        this.m_palleteSelectedStep = stepvisual;
    }

    public void showErrorDialog(Exception cause) {
        this.m_mainApplication.showErrorDialog(cause);
    }

    public void showInfoDialog(Object information, String title, boolean isWarning) {
        this.m_mainApplication.showInfoDialog(information, title, isWarning);
    }

    public void setFlowLayoutOperation(VisibleLayout.LayoutOperation opp) {
        if (this.getCurrentTabIndex() < this.getNumTabs() && this.getCurrentTabIndex() >= 0) {
            this.m_flowGraphs.get(this.getCurrentTabIndex()).setFlowLayoutOperation(opp);
        }
    }

    public boolean getSnapToGrid() {
        return ((JToggleButton)this.m_mainToolBar.getWidget(MainKFPerspectiveToolBar.Widgets.SNAP_TO_GRID_BUTTON.toString())).isSelected();
    }

    public void clearDesignPaletteSelection() {
        this.m_stepTree.clearSelection();
    }

    public String getPasteBuffer() {
        return this.m_pasteBuffer;
    }

    protected void setPasteBuffer(String serializedFlow) {
        this.m_pasteBuffer = serializedFlow;
    }

    public void copyStepsToClipboard(List<StepVisual> steps) throws WekaException {
        if (steps.size() > 0) {
            this.m_pasteBuffer = VisibleLayout.serializeStepsToJSON(steps, "Clipboard copy");
            this.getMainToolBar().enableWidgets(MainKFPerspectiveToolBar.Widgets.PASTE_BUTTON.toString());
        }
    }

    public void copyFlowToClipboard(Flow flow) throws WekaException {
        this.m_pasteBuffer = JSONFlowUtils.flowToJSON(flow);
        this.getMainToolBar().enableWidgets(MainKFPerspectiveToolBar.Widgets.PASTE_BUTTON.toString());
    }

    public TemplateManager getTemplateManager() {
        return this.m_templateManager;
    }

    public synchronized void addUntitledTab() {
        if (this.getNumTabs() == 0 || this.getAllowMultipleTabs()) {
            this.addTab("Untitled" + this.m_untitledCount++);
        } else {
            this.m_flowGraphs.get(this.getCurrentTabIndex()).stopFlow();
            this.m_flowGraphs.get(this.getCurrentTabIndex()).setFlow(new Flow());
        }
    }

    public synchronized void addTab(String tabTitle) {
        VisibleLayout newLayout = new VisibleLayout(this);
        this.m_flowGraphs.add(newLayout);
        this.m_flowTabs.add(tabTitle, newLayout);
        this.m_flowTabs.setTabComponentAt(this.getNumTabs() - 1, new CloseableTabTitle(this.m_flowTabs, "(Ctrl+W)", new CloseableTabTitle.ClosingCallback(){

            @Override
            public void tabClosing(int tabIndex) {
                if (MainKFPerspective.this.getAllowMultipleTabs()) {
                    MainKFPerspective.this.removeTab(tabIndex);
                }
            }
        }));
        this.setActiveTab(this.getNumTabs() - 1);
    }

    public void setCurrentTabTitleEditedStatus(boolean edited) {
        CloseableTabTitle current = (CloseableTabTitle)this.m_flowTabs.getTabComponentAt(this.getCurrentTabIndex());
        current.setBold(edited);
    }

    public int getCurrentTabIndex() {
        return this.m_flowTabs.getSelectedIndex();
    }

    public synchronized int getNumTabs() {
        return this.m_flowTabs.getTabCount();
    }

    public synchronized String getTabTitle(int index) {
        if (index < this.getNumTabs() && index >= 0) {
            return this.m_flowTabs.getTitleAt(index);
        }
        throw new IndexOutOfBoundsException("Tab index " + index + " is out of range!");
    }

    public synchronized void setActiveTab(int tabIndex) {
        if (tabIndex < this.getNumTabs() && tabIndex >= 0) {
            this.m_flowTabs.setSelectedIndex(tabIndex);
            VisibleLayout current = this.getCurrentLayout();
            this.m_mainToolBar.enableWidget(MainKFPerspectiveToolBar.Widgets.SAVE_FLOW_BUTTON.toString(), !current.isExecuting());
            this.m_mainToolBar.enableWidget(MainKFPerspectiveToolBar.Widgets.SAVE_FLOW_AS_BUTTON.toString(), !current.isExecuting());
            this.m_mainToolBar.enableWidget(MainKFPerspectiveToolBar.Widgets.PLAY_PARALLEL_BUTTON.toString(), !current.isExecuting());
            this.m_mainToolBar.enableWidget(MainKFPerspectiveToolBar.Widgets.PLAY_SEQUENTIAL_BUTTON.toString(), !current.isExecuting());
            this.m_mainToolBar.enableWidget(MainKFPerspectiveToolBar.Widgets.ZOOM_OUT_BUTTON.toString(), !current.isExecuting());
            this.m_mainToolBar.enableWidget(MainKFPerspectiveToolBar.Widgets.ZOOM_IN_BUTTON.toString(), !current.isExecuting());
            if (current.getZoomSetting() == 50) {
                this.m_mainToolBar.enableWidget(MainKFPerspectiveToolBar.Widgets.ZOOM_OUT_BUTTON.toString(), false);
            }
            if (current.getZoomSetting() == 200) {
                this.m_mainToolBar.enableWidget(MainKFPerspectiveToolBar.Widgets.ZOOM_IN_BUTTON.toString(), false);
            }
            this.m_mainToolBar.enableWidget(MainKFPerspectiveToolBar.Widgets.CUT_BUTTON.toString(), current.getSelectedSteps().size() > 0 && !current.isExecuting());
            this.m_mainToolBar.enableWidget(MainKFPerspectiveToolBar.Widgets.COPY_BUTTON.toString(), current.getSelectedSteps().size() > 0 && !current.isExecuting());
            this.m_mainToolBar.enableWidget(MainKFPerspectiveToolBar.Widgets.DELETE_BUTTON.toString(), current.getSelectedSteps().size() > 0 && !current.isExecuting());
            this.m_mainToolBar.enableWidget(MainKFPerspectiveToolBar.Widgets.SELECT_ALL_BUTTON.toString(), current.numSteps() > 0 && !current.isExecuting());
            this.m_mainToolBar.enableWidget(MainKFPerspectiveToolBar.Widgets.PASTE_BUTTON.toString(), this.getPasteBuffer() != null && this.getPasteBuffer().length() > 0 && !current.isExecuting());
            this.m_mainToolBar.enableWidget(MainKFPerspectiveToolBar.Widgets.STOP_BUTTON.toString(), current.isExecuting());
            this.m_mainToolBar.enableWidget(MainKFPerspectiveToolBar.Widgets.UNDO_BUTTON.toString(), !current.isExecuting() && current.getUndoBufferSize() > 0);
            this.m_mainToolBar.enableWidget(MainKFPerspectiveToolBar.Widgets.NEW_FLOW_BUTTON.toString(), !current.isExecuting() && this.getAllowMultipleTabs());
        }
    }

    public void closeAllTabs() {
        for (int i = 0; i < this.getNumTabs(); ++i) {
            this.removeTab(i);
        }
    }

    public synchronized void removeTab(int tabIndex) {
        if (tabIndex < 0 || tabIndex >= this.getNumTabs()) {
            return;
        }
        if (this.m_flowGraphs.get(tabIndex).getEdited()) {
            String tabTitle = this.m_flowTabs.getTitleAt(tabIndex);
            String message = "\"" + tabTitle + "\" has been modified. Save changes " + "before closing?";
            int result = JOptionPane.showConfirmDialog(this, message, "Save changes", 1);
            if (result == 0) {
                this.saveLayout(tabIndex, false);
            } else if (result == 2) {
                return;
            }
        }
        this.m_flowTabs.remove(tabIndex);
        this.m_flowGraphs.remove(tabIndex);
        if (this.getCurrentTabIndex() < 0) {
            this.m_mainToolBar.disableWidgets(MainKFPerspectiveToolBar.Widgets.SAVE_FLOW_BUTTON.toString(), MainKFPerspectiveToolBar.Widgets.SAVE_FLOW_AS_BUTTON.toString());
        }
    }

    public VisibleLayout getCurrentLayout() {
        if (this.getCurrentTabIndex() >= 0) {
            return this.m_flowGraphs.get(this.getCurrentTabIndex());
        }
        return null;
    }

    public VisibleLayout getLayoutAt(int index) {
        if (index >= 0 && index < this.m_flowGraphs.size()) {
            return this.m_flowGraphs.get(index);
        }
        throw new IndexOutOfBoundsException("Flow index " + index + " is out of range!");
    }

    public boolean getAllowMultipleTabs() {
        return this.m_allowMultipleTabs;
    }

    public void setAllowMultipleTabs(boolean allow) {
        this.m_allowMultipleTabs = allow;
    }

    public <T> T getSetting(Settings.SettingKey propKey, T defaultVal) {
        return this.m_mainApplication.getApplicationSettings().getSetting(this.getPerspectiveID(), propKey, defaultVal, null);
    }

    public void notifyIsDirty() {
        this.firePropertyChange("PROP_DIRTY", null, null);
    }

    protected void saveLayout(int tabIndex, boolean showDialog) {
        this.m_flowGraphs.get(tabIndex).saveLayout(showDialog);
    }

    public void loadLayout() {
        File lFile = null;
        int returnVal = this.m_FileChooser.showOpenDialog(this);
        if (returnVal == 0) {
            lFile = this.m_FileChooser.getSelectedFile();
            this.loadLayout(lFile, true);
        }
    }

    public void loadLayout(File fFile, boolean newTab) {
        File absoluteF = fFile.getAbsoluteFile();
        if (!newTab) {
            this.m_flowGraphs.get(this.getCurrentTabIndex()).loadLayout(fFile, false);
            this.m_flowGraphs.get(this.getCurrentTabIndex()).getEnvironment().addVariable(FLOW_PARENT_DIRECTORY_VARIABLE_KEY, absoluteF.getParent());
        } else {
            String tabTitle = fFile.toString();
            if ((tabTitle = tabTitle.substring(tabTitle.lastIndexOf(File.separator) + 1, tabTitle.length())).lastIndexOf(46) > 0) {
                tabTitle = tabTitle.substring(0, tabTitle.lastIndexOf(46));
            }
            this.addTab(tabTitle);
            VisibleLayout current = this.getCurrentLayout();
            current.loadLayout(fFile, false);
            current.getEnvironment().addVariable(FLOW_PARENT_DIRECTORY_VARIABLE_KEY, absoluteF.getParent());
            this.setActiveTab(this.getCurrentTabIndex());
        }
    }

    protected void setCurrentTabTitle(String title) {
        this.m_flowTabs.setTitleAt(this.getCurrentTabIndex(), title);
    }

    public boolean isMemoryLow() {
        return m_memory.memoryIsLow();
    }

    public boolean showMemoryIsLow() {
        return m_memory.showMemoryIsLow();
    }

    public boolean getDebug() {
        return this.getMainApplication().getApplicationSettings().getSetting(this.getPerspectiveID(), KFDefaults.LOGGING_LEVEL_KEY, LoggingLevel.BASIC, Environment.getSystemWide()).ordinal() == LoggingLevel.DEBUGGING.ordinal();
    }

    public MainKFPerspectiveToolBar getMainToolBar() {
        return this.m_mainToolBar;
    }

    @Override
    public void setActive(boolean active) {
        if (active && !this.getMainApplication().getApplicationID().equalsIgnoreCase("knowledgeflow") && this.getNumTabs() == 0) {
            this.addUntitledTab();
        }
    }

    @Override
    public List<JMenu> getMenus() {
        return this.m_mainToolBar.getMenus();
    }

    @Override
    public Defaults getDefaultSettings() {
        return new KFDefaults();
    }

    @Override
    public boolean okToBeActive() {
        return true;
    }

    @Override
    public void settingsChanged() {
        Settings settings = this.getMainApplication().getApplicationSettings();
        int fontSize = settings.getSetting("knowledgeflow.main", new Settings.SettingKey("knowledgeflow.main.logMessageFontSize", "", ""), -1);
        for (VisibleLayout v : this.m_flowGraphs) {
            v.getLogPanel().setLoggingFontSize(fontSize);
        }
    }

    @Override
    public boolean acceptsInstances() {
        GUIApplication mainApp = this.getMainApplication();
        if (mainApp.getApplicationID().equals("workbench")) {
            boolean sendToAll = mainApp.getApplicationSettings().getSetting("weka.gui.explorer.preprocesspanel", PreprocessPanel.PreprocessDefaults.ALWAYS_SEND_INSTANCES_TO_ALL_KEY, Boolean.valueOf(PreprocessPanel.PreprocessDefaults.ALWAYS_SEND_INSTANCES_TO_ALL), Environment.getSystemWide());
            return !sendToAll;
        }
        return false;
    }

    @Override
    public void setInstances(Instances instances) {
        this.addUntitledTab();
        VisibleLayout newL = this.m_flowGraphs.get(this.m_flowGraphs.size() - 1);
        MemoryBasedDataSource memoryBasedDataSource = new MemoryBasedDataSource();
        memoryBasedDataSource.setInstances(instances);
        StepManagerImpl newS = new StepManagerImpl(memoryBasedDataSource);
        newL.addStep(newS, 30, 30);
    }
}

