/*
 * Decompiled with CFR 0.152.
 */
package weka.knowledgeflow;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import weka.knowledgeflow.steps.Step;

public class Data
implements Serializable {
    private static final long serialVersionUID = 239235113781041619L;
    protected Step m_sourceStep;
    protected String m_connectionName;
    protected Map<String, Object> m_payloadMap = new LinkedHashMap<String, Object>();

    public Data() {
    }

    public Data(String connectionName) {
        this.setConnectionName(connectionName);
    }

    public Data(String connectionName, Object primaryPayload) {
        this(connectionName);
        this.setPayloadElement(connectionName, primaryPayload);
    }

    public void setSourceStep(Step sourceStep) {
        this.m_sourceStep = sourceStep;
    }

    public Step getSourceStep() {
        return this.m_sourceStep;
    }

    public void setConnectionName(String name) {
        this.m_connectionName = name;
    }

    public String getConnectionName() {
        return this.m_connectionName;
    }

    public <T> T getPrimaryPayload() {
        return (T)this.m_payloadMap.get(this.m_connectionName);
    }

    public <T> T getPayloadElement(String name) {
        return (T)this.m_payloadMap.get(name);
    }

    public <T> T getPayloadElement(String name, T defaultValue) {
        T result = this.getPayloadElement(name);
        if (result == null) {
            return defaultValue;
        }
        return result;
    }

    public void setPayloadElement(String name, Object value) {
        this.m_payloadMap.put(name, value);
    }

    public void clearPayload() {
        this.m_payloadMap.clear();
    }
}

