package rs.fon.is.weka.classifier;

import weka.classifiers.Evaluation;
import weka.classifiers.lazy.IBk;
import weka.core.Instances;
import weka.core.converters.ConverterUtils.DataSource;

public class KNNClassificatorFromFile {

	private static String trainingDataFileName = "data/diabetes2.arff";
	private static String testDataFileName = "data/diabetes2-test.arff";

	public static void main(String[] args) throws Exception {

		// load data
		DataSource loader = new DataSource(trainingDataFileName);
		Instances data = loader.getDataSet();
		data.setClassIndex(data.numAttributes() - 1);

		
		// Create the IBk classifier (KNN implementation in Weka)
		IBk knnClf = new IBk();
		knnClf.setKNN(5);
		knnClf.buildClassifier(data);

        // test with different k values
		
		// output generated model
		System.out.println(knnClf);
		
		
		// load test data
		DataSource loaderTest = new DataSource(testDataFileName);
		Instances testDataset = loaderTest.getDataSet();
		testDataset.setClassIndex(testDataset.numAttributes() - 1);
		
		Evaluation eval = new Evaluation(testDataset);
		eval.evaluateModel(knnClf, testDataset);
		
		// Print the result as in Weka explorer
		System.out.println(eval.toSummaryString());
		
		// Get the confusion matrix
		System.out.println(eval.toMatrixString());

        // compare values for different k
	}
}
