package rs.fon.is.weka.classifier;

import weka.classifiers.CostMatrix;
import weka.classifiers.Evaluation;
import weka.classifiers.lazy.IBk;
import weka.classifiers.meta.CostSensitiveClassifier;
import weka.core.Instances;
import weka.core.converters.ConverterUtils.DataSource;

public class WeightedKNNClassificatorFromFile {

	private static String trainingDataFileName = "data/diabetes2.arff";
	private static String testDataFileName = "data/diabetes2-test.arff";

	public static void main(String[] args) throws Exception {

		// load data
		DataSource loader = new DataSource(trainingDataFileName);
		Instances data = loader.getDataSet();
		data.setClassIndex(data.numAttributes() - 1);

		
		// Create the IBk classifier (KNN implementation in Weka)
		IBk knnClf = new IBk(); 
		knnClf.setKNN(5);
		knnClf.buildClassifier(data);
		
		
		// define the cost matrix
		CostMatrix costMatrix = new CostMatrix(2);
		costMatrix.setElement(0, 1, 2);		// row, column, value
		
		System.out.println(costMatrix);

		
		// create CostSensitiveClassifier instance and define the classifier ant the cost matrix
		CostSensitiveClassifier csClf = new CostSensitiveClassifier();
		csClf.setClassifier(knnClf);
		csClf.setCostMatrix(costMatrix);
		csClf.buildClassifier(data);
		
		// output generated model
		System.out.println(knnClf);
		
		
		// load test data
		DataSource loaderTest = new DataSource(testDataFileName);
		Instances testDataset = loaderTest.getDataSet();
		testDataset.setClassIndex(testDataset.numAttributes() - 1);
		
		Evaluation eval = new Evaluation(testDataset);
		eval.evaluateModel(csClf, testDataset);
		
		// Print the result as in Weka explorer
		System.out.println(eval.toSummaryString());
		
		// Get the confusion matrix
		System.out.println(eval.toMatrixString());
	}
}
