package cars.tires;

import java.util.GregorianCalendar;
import java.util.LinkedList;

import cars.tires.searchengine.TireSearchEngine;

public class CarRepairShop implements TireSearchEngine {
	
	private LinkedList<Tire> tires = new LinkedList<Tire>();

	@Override
	public void displayOffer(int width, int height, int diameter,
			boolean isWinter) {
		
		for (Tire tire : tires) {
			String[] dimensions = tire.getDimensions().split("/");
			if ( dimensions[0].equals(String.valueOf(width)) &&
					dimensions[1].equals(String.valueOf(height)) &&
						dimensions[2].equals(String.valueOf(diameter)) &&
							tire.isWinterTire() )
				System.out.println( tire );
		}

	}

	@Override
	public void addTire(Tire tire) {
		if ( tire != null && tire.getDateMade().before(new GregorianCalendar()) )
			tires.addFirst(tire);
		else System.out.println("Error!");
	}
	
	public void reverseTheOrder() {
		for (int i = 0; i < tires.size()/2; i++) {
			Tire tFront = tires.get(i);
			Tire tRear = tires.get(tires.size() - 1 - i);
			tires.set(i, tRear);
			tires.set(tires.size() - 1 - i, tFront);
		}
	}

}
