package gallery;

import java.util.GregorianCalendar;
import java.util.LinkedList;

import exhibits.Exhibit;
import exhibits.sculptures.Sculpture;

public class Gallery {
	
	private Exhibit[] exhibits;
	
	public Gallery() {
		exhibits = new Exhibit[100];
	}
	
	private int findFreeSpace() {
		for (int i = 0; i < exhibits.length; i++) {
			if ( exhibits[i] == null ) return i;
		}
		return -1;
	}
	
	public void addNewExhibit(Exhibit e) {
		int freeIndex = findFreeSpace();
		if( e != null && freeIndex >= 0) {
			exhibits[freeIndex] = e;
			exhibits[freeIndex].setDateReceived(new GregorianCalendar());
		} else {
			System.out.println("Error!");
		}
	}
	
	public void enableDiscount(double discount) {
		int prevYear = (new GregorianCalendar()).get(GregorianCalendar.YEAR) - 1;
		
		for (int i = 0; i < exhibits.length; i++) {
			if( exhibits[i] != null &&
					exhibits[i].getDateReceived().get(GregorianCalendar.YEAR) == prevYear) {
				double newPrice = exhibits[i].getPrice() * (1 - discount/100);
				exhibits[i].setPrice(newPrice);
			}
		}
	}
	
	public Sculpture[] bronzeMostExpencive() {
		LinkedList<Sculpture> bronzeSculptures = new LinkedList<>();
		
		for (int i = 0; i < exhibits.length; i++) {
			if( exhibits[i] != null && exhibits[i] instanceof Sculpture) {
				Sculpture s = (Sculpture)exhibits[i];
				if ( s.getMaterial().equalsIgnoreCase("bronze") ) {
					
					if (bronzeSculptures.isEmpty())
						bronzeSculptures.add(s);
					else {
						boolean added = false;
						for (int j = 0; j < bronzeSculptures.size(); j++) {
							if( bronzeSculptures.get(j).getPrice() <= s.getPrice() ) {
								bronzeSculptures.add(j, s);
								added = true;
								break;
							}
						}
						if(!added)
							bronzeSculptures.addLast(s);
					}
				}				
			}
		}
		
		Sculpture[] result = new Sculpture[2];
		result[0] = bronzeSculptures.getFirst();
		result[1] = bronzeSculptures.get(1);
		return result;
	}

}






