package exhibits;

import java.util.GregorianCalendar;

public abstract class Exhibit {

	private String name;
	
	private String author;
	
	private double price;
	
	private GregorianCalendar dateReceived;

	public String getName() {
		return name;
	}

	public void setName(String name) {
		if ( name != null && !name.isEmpty() )
			this.name = name;
		else System.out.println("Error!");
	}

	public String getAuthor() {
		return author;
	}

	public void setAuthor(String author) {
		if ( author != null && !author.equals("") )
			this.author = author;
		else System.out.println("Error!");
	}

	public double getPrice() {
		return price;
	}

	public void setPrice(double price) {
		if ( price > 0 )
			this.price = price;
		else System.out.println("Error!");
	}

	public GregorianCalendar getDateReceived() {
		return dateReceived;
	}

	public void setDateReceived(GregorianCalendar dateReceived) {
		if (dateReceived != null && dateReceived.before(new GregorianCalendar()))
			this.dateReceived = dateReceived;
		else System.out.println("Error!");
	}
	
	public abstract void print(); 
	
	
}
