package gallery;

import java.util.GregorianCalendar;
import java.util.LinkedList;

import exhibits.Exhibit;
import exhibits.sculptures.Sculpture;

public class Gallery {
	
	private Exhibit[] exhibits;
	
	public Gallery() {
		exhibits = new Exhibit[100];
	}
	
	public void addNewExhibit(Exhibit e) {
		if ( e == null ) {
			System.out.println("Error!");
			return;
		}
		
		for (int i = 0; i < exhibits.length; i++) {
			if ( exhibits[i] == null ) {
				exhibits[i] = e;
				exhibits[i].setDateReceived(new GregorianCalendar());
				return;
			}
		}
		
		System.out.println("Error! No free space in the gallery!");
		
	}
	
	public void enableDiscount(double discount) {
		int prevYear = (new GregorianCalendar()).get(GregorianCalendar.YEAR) - 1;
		
		for (int i = 0; i < exhibits.length; i++) {
			if ( exhibits[i] != null &&
					exhibits[i].getDateReceived().get(GregorianCalendar.YEAR) == prevYear) {
				double newPrice = exhibits[i].getPrice() * (1 - discount/100);
				exhibits[i].setPrice(newPrice);
			}
		}
	}
	
	public Sculpture[] mostExpenciveBronzeSculptues() {
		
		LinkedList<Sculpture> bronzeSculptures = new LinkedList<>();
		
		for (int i = 0; i < exhibits.length; i++) {
			if ( exhibits[i] != null && exhibits[i] instanceof Sculpture ) {
				Sculpture s = (Sculpture)exhibits[i];
				if ( s.getMaterial().equals("bronze") ) {
					
					if( bronzeSculptures.isEmpty() ) 
						bronzeSculptures.add(s);
					else {
						boolean added = false;
						for (int j = 0; j < bronzeSculptures.size(); j++) {
							if(bronzeSculptures.get(j).getPrice() <= s.getPrice()) {
								bronzeSculptures.add(j, s);
								added = true;
								break;
							}
						}
						if (!added)
							bronzeSculptures.addLast(s);
					}
				}
			}
		}
		Sculpture[] result = new Sculpture[2];
		result[0] = bronzeSculptures.getFirst();
		result[1] = bronzeSculptures.get(1);
		return result;
	}

}
