package cars;

import java.util.GregorianCalendar;
import java.util.LinkedList;

import cars.tires.Tire;
import cars.tires.searchengine.TireSearchEngine;

public class CarRepairShop implements TireSearchEngine {
	
	private LinkedList<Tire> tires = new LinkedList<Tire>();

	@Override
//	public void displayOffer(int width, int height, int diameter,
//			boolean isWinter) {
//		
//		for (Tire tire : tires) {
//			String[] dimensions = tire.getDimensions().split("/");
//			if ( dimensions[0].equals(String.valueOf(width)) &&
//					dimensions[1].equals(String.valueOf(height)) &&
//						dimensions[2].equals(String.valueOf(diameter)) &&
//							tire.isWinterTire() == isWinter )
//				System.out.println( tire );
//		}
//
//	}
	
	public void displayOffer(int width, int height, int diameter,
			boolean isWinter) {
		
		String dimensions = width + "/" + height + "/" + diameter;
		for (int i = 0; i < tires.size(); i++) {
			if (tires.get(i).getDimensions().equals(dimensions) && 
					tires.get(i).isWinterTire() == isWinter )
				System.out.println( tires.get(i) );
		}
		
	}

	@Override
	public void addTire(Tire tire) {
		if ( tire != null && tire.getDateMade().before(new GregorianCalendar()) )
			tires.addFirst(tire);
		else System.out.println("Error!");
	}
	
	public void reverseTheList() {
		
		LinkedList<Tire> reversedList = new LinkedList<Tire>();
		for (int i = tires.size(); i >=0 ; i--) {
			reversedList.add(tires.get(i));
		}
		
		tires = reversedList;
	}
	
	public void reverseTheOrder2() {
		for (int i = 0; i < tires.size()/2; i++) {
			Tire tFront = tires.get(i);
			Tire tRear = tires.get(tires.size() - 1 - i);
			tires.set(i, tRear);
			tires.set(tires.size() - 1 - i, tFront);
		}
	}

}
