package labs11.task2;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;

public class FileIO {
	
	public void readFromFileAndPrint() {
		BufferedReader in = null;
		try {
			in = new BufferedReader(new FileReader("text.txt"));
			boolean eof = false;
			String text = "";
			while(!eof) {
				String s = in.readLine();
				if ( s != null )
					text = text + s + "\n";
				else eof = true;
			}
			System.out.println("The content of the file:\n" + text);			
		} catch (FileNotFoundException e) {
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		} finally {
			if ( in != null )
				try {
					in.close();
				} catch (IOException e) {
					e.printStackTrace(); }
		}
	}
	
	public void printToFile(String s1, String s2) throws IOException {
		PrintWriter out = new PrintWriter(new FileWriter("text2.txt"));
		out.println(s1);
		out.println(s2);
		out.close();
	}
	
	public void writeNumbersToFile() throws IOException {
		DataOutputStream out = 
				new DataOutputStream(new FileOutputStream("numbers.out"));
		for(int i = 45; i <= 78; i = i + 11) {
			out.writeInt(i);
			out.writeChar('\n');
		}
		
		out.close();
	}
	
	public void readNumbersFromFile() throws IOException {
		DataInputStream in = 
				new DataInputStream(new FileInputStream("numbers.out"));
		int sum = 0;
		while( in.available() > 0 ) {
			sum += in.readInt();
			in.readChar();
		}
		
		System.out.println("Sum: " + sum);
		
		in.close();
	}

}



