package labs12.assignment1;

import java.io.EOFException;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.LinkedList;

public class Group {

	private LinkedList<Person> members = 
			new LinkedList<Person>();
	
	public void addMember(Person p) {
		if (p != null )
			members.add(p);
		else System.out.println("Error!");
	}
	
	public void serializeMembers() throws IOException {
		ObjectOutputStream out = 
				new ObjectOutputStream(new FileOutputStream("group.ser"));
		
		for (int i = 0; i < members.size(); i++) {
			out.writeObject(members.get(i));
		}
		
		out.close();
	}
	
	
	public void readMembersFromFile() throws Exception {
		ObjectInputStream in = 
				new ObjectInputStream(new FileInputStream("group.ser"));
		
		members.clear();
		
		try {
			while(true) {
				Object o = in.readObject();
				if (o instanceof Person) 
					addMember((Person)o);
			}
		} catch (EOFException e) {
			System.out.println("Reached the end of the file!");
		}
		
		in.close();
	}
	
	public void printMembers() {
		if ( members.isEmpty() )
			System.out.println("No members");
		else {
			for (Person member : members) {
				System.out.println(member.getName() + " " + 
						member.getSurname() + member.getAge());
			}
		}
	}
	
	
	
	
	
}







