package labs12.assignment2.gui;

import java.awt.BorderLayout;
import java.awt.EventQueue;

import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

import labs12.assignment2.business_logic.CurrencyConverter;

import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.JButton;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.awt.event.ActionEvent;

public class ConverterGUI extends JFrame {

	private JPanel contentPane;
	private JLabel lblAmountInRsd;
	private JLabel lblAmountInEuros;
	private JTextField rsdTextField;
	private JTextField euroTextField;
	private JButton d2eButton;
	private JButton e2dButton;
	private JLabel errorLabel;

	/**
	 * Launch the application.
	 */
	public static void main(String[] args) {
		EventQueue.invokeLater(new Runnable() {
			public void run() {
				try {
					ConverterGUI frame = new ConverterGUI();
					frame.setVisible(true);
				} catch (Exception e) {
					e.printStackTrace();
				}
			}
		});
	}

	/**
	 * Create the frame.
	 */
	public ConverterGUI() {
		setResizable(false);
		setTitle("Currency converter");
		setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		setBounds(100, 100, 384, 207);
		contentPane = new JPanel();
		contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
		setContentPane(contentPane);
		contentPane.setLayout(null);
		contentPane.add(getLblAmountInRsd());
		contentPane.add(getLblAmountInEuros());
		contentPane.add(getRsdTextField());
		contentPane.add(getEuroTextField());
		contentPane.add(getD2eButton());
		contentPane.add(getE2dButton());
		contentPane.add(getErrorLabel());
	}
	private JLabel getLblAmountInRsd() {
		if (lblAmountInRsd == null) {
			lblAmountInRsd = new JLabel("Amount in RSD");
			lblAmountInRsd.setBounds(37, 43, 99, 21);
		}
		return lblAmountInRsd;
	}
	private JLabel getLblAmountInEuros() {
		if (lblAmountInEuros == null) {
			lblAmountInEuros = new JLabel("Amount in Euros");
			lblAmountInEuros.setBounds(213, 43, 99, 21);
		}
		return lblAmountInEuros;
	}
	private JTextField getRsdTextField() {
		if (rsdTextField == null) {
			rsdTextField = new JTextField();
			rsdTextField.setBounds(37, 75, 99, 20);
			rsdTextField.setColumns(10);
		}
		return rsdTextField;
	}
	private JTextField getEuroTextField() {
		if (euroTextField == null) {
			euroTextField = new JTextField();
			euroTextField.setBounds(213, 75, 99, 20);
			euroTextField.setColumns(10);
		}
		return euroTextField;
	}
	private JButton getD2eButton() {
		if (d2eButton == null) {
			d2eButton = new JButton("Convert D2E");
			d2eButton.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					errorLabel.setText("");
					
					String rsdStr = rsdTextField.getText();
					try {
						double rsd = Double.parseDouble(rsdStr);
						double euro = CurrencyConverter.convertRSDToEuro(rsd);
						DecimalFormat formatter = new DecimalFormat();
						euroTextField.setText( formatter.format(euro) );
					} catch (NumberFormatException e1) {
						errorLabel.setText("Error! Incorrect input! Try again");
						rsdTextField.setText("");
						euroTextField.setText("");
					}
				}
			});
			d2eButton.setBounds(37, 109, 99, 21);
		}
		return d2eButton;
	}
	private JButton getE2dButton() {
		if (e2dButton == null) {
			e2dButton = new JButton("Convert E2D");
			e2dButton.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
				}
			});
			e2dButton.setBounds(213, 108, 99, 23);
		}
		return e2dButton;
	}
	private JLabel getErrorLabel() {
		if (errorLabel == null) {
			errorLabel = new JLabel("");
			errorLabel.setBounds(37, 153, 275, 14);
		}
		return errorLabel;
	}
}
