package labs12.assignment1;

import java.io.EOFException;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.LinkedList;

public class Group {

	private LinkedList<Person> members = new LinkedList<Person>();
	
	public void addMember(Person p) {
		if (p != null)
			members.add(p);
		else throw new RuntimeException("Null input parameter!");
	}
	
	public void serializeMembersList() throws IOException {
		ObjectOutputStream out = 
				new ObjectOutputStream(new FileOutputStream("group.ser"));
		
		for (int i = 0; i < members.size(); i++) {
			out.writeObject(members.get(i));
		}
		
		out.close();
	}
	
	public void deserializeMembers() throws Exception {
		
		members.clear();
		
		ObjectInputStream in = 
				new ObjectInputStream(new FileInputStream("group.ser"));
		
		while(true) {
			try {
				Object o = in.readObject();
				if (o instanceof Person) {
					addMember((Person)o);
				}
			} catch (EOFException e) {
				System.out.println("Terminating the reading process");
				break;
			}
		}
		
		in.close();
		
	}
	
	public void print() {
		if ( members.isEmpty() )
			System.out.println("No group members");
		else
			for (Person person : members) {
				System.out.println(person);
			}
	}
}






