package labs12.assignment2.gui;

import java.awt.BorderLayout;
import java.awt.EventQueue;

import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

import labs12.assignment2.business_logic.CurrencyConverter;

import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.JButton;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.awt.event.ActionEvent;
import javax.swing.SwingConstants;

public class ConverterGUI extends JFrame {

	private JPanel contentPane;
	private JLabel lblAmountInRsd;
	private JLabel lblAmountInEuros;
	private JTextField rsdTextField;
	private JTextField euroTextField;
	private JButton btnConvertRsdeuro;
	private JButton btnEurotorsd;
	private JLabel errorLabel;

	/**
	 * Launch the application.
	 */
	public static void main(String[] args) {
		EventQueue.invokeLater(new Runnable() {
			public void run() {
				try {
					ConverterGUI frame = new ConverterGUI();
					frame.setVisible(true);
				} catch (Exception e) {
					e.printStackTrace();
				}
			}
		});
	}

	/**
	 * Create the frame.
	 */
	public ConverterGUI() {
		setTitle("Currency converter");
		setResizable(false);
		setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		setBounds(100, 100, 332, 201);
		contentPane = new JPanel();
		contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
		setContentPane(contentPane);
		contentPane.setLayout(null);
		contentPane.add(getLblAmountInRsd());
		contentPane.add(getLblAmountInEuros());
		contentPane.add(getRsdTextField());
		contentPane.add(getEuroTextField());
		contentPane.add(getBtnConvertRsdeuro());
		contentPane.add(getBtnEurotorsd());
		contentPane.add(getErrorLabel());
	}
	private JLabel getLblAmountInRsd() {
		if (lblAmountInRsd == null) {
			lblAmountInRsd = new JLabel("Amount in RSD");
			lblAmountInRsd.setBounds(21, 26, 106, 23);
		}
		return lblAmountInRsd;
	}
	private JLabel getLblAmountInEuros() {
		if (lblAmountInEuros == null) {
			lblAmountInEuros = new JLabel("Amount in Euros");
			lblAmountInEuros.setBounds(191, 26, 106, 23);
		}
		return lblAmountInEuros;
	}
	private JTextField getRsdTextField() {
		if (rsdTextField == null) {
			rsdTextField = new JTextField();
			rsdTextField.setBounds(21, 60, 106, 20);
			rsdTextField.setColumns(10);
		}
		return rsdTextField;
	}
	private JTextField getEuroTextField() {
		if (euroTextField == null) {
			euroTextField = new JTextField();
			euroTextField.setBounds(191, 60, 106, 20);
			euroTextField.setColumns(10);
		}
		return euroTextField;
	}
	private JButton getBtnConvertRsdeuro() {
		if (btnConvertRsdeuro == null) {
			btnConvertRsdeuro = new JButton("RSD-to-Euro");
			btnConvertRsdeuro.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent arg0) {
					errorLabel.setText("");
					String rsdString = rsdTextField.getText();
					try {
						double rsdAmount = Double.parseDouble(rsdString);
						double euroAmount = CurrencyConverter.convertRSDToEuros(rsdAmount);
						DecimalFormat df = new DecimalFormat();			
						euroTextField.setText( df.format(euroAmount) );
					} catch (NumberFormatException e) {
						errorLabel.setText("Error! Incorrect input! Try again!");
						rsdTextField.setText("");
					}
				}
			});
			btnConvertRsdeuro.setBounds(21, 102, 106, 23);
		}
		return btnConvertRsdeuro;
	}
	private JButton getBtnEurotorsd() {
		if (btnEurotorsd == null) {
			btnEurotorsd = new JButton("Euro-toRSD");
			btnEurotorsd.setBounds(191, 102, 106, 23);
		}
		return btnEurotorsd;
	}
	private JLabel getErrorLabel() {
		if (errorLabel == null) {
			errorLabel = new JLabel("");
			errorLabel.setHorizontalAlignment(SwingConstants.CENTER);
			errorLabel.setBounds(21, 145, 276, 14);
		}
		return errorLabel;
	}
}
