package task2;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Scanner;

public class KeyboardInput {
	
	public static void readAndWrite() {
		BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
		
		System.out.println("Please enter some text to test the method");
		try {
			String s = in.readLine();
			System.out.println("text: " + s);
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		
	}
	
	public static void readAndWriteV2() {
		Scanner scanner = new Scanner(System.in);
		System.out.println("Please enter some text");
		String s = scanner.nextLine();
		System.out.println("You've entered: " + s);
	}
	
	public static void readNumberPrintSquare() {
		BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
		
		System.out.println("Please enter a decimal number");
		try {
			String numberStr = in.readLine();
			double number = Double.parseDouble(numberStr);
			System.out.println("The square of the input is: " + Math.pow(number, 2));
		} catch (NumberFormatException e) {
			System.err.println("The string cannot be parsed to double");
			e.printStackTrace();
		} catch (IOException e) {
			System.out.println("Problem with reading from keyboard: " +e.getMessage());
			e.printStackTrace();
		}
		
	}
	
	public static void readNumberPrintSquareV2() {
		Scanner scanner = new Scanner(System.in);
		System.out.println("Please enter a decimal number");
		double number = scanner.nextDouble();
		System.out.println("The square of the input is " + number*number);
	}
	
	
	
	public static void main(String[] args) {
		//readAndWriteV2();
		readNumberPrintSquareV2();
	}

}
