package labs13.task1.gui;

import java.awt.BorderLayout;
import java.awt.EventQueue;

import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.JTextArea;

import java.awt.Dimension;

import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.JButton;

import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;
import java.io.IOException;

import labs13.task1.bussiness_logic.TextDemo;

public class TextEditorGUI extends JFrame {

	private JPanel contentPane;
	private JTextArea mainTextArea;
	private JPanel westPanel;
	private JLabel lblNewLabel;
	private JTextField fNameTextField;
	private JButton btnLoad;
	private JButton btnDelete;
	private JButton btnSave;
	private JButton btnExit;
	
	private TextDemo tDemo = new TextDemo();
	private JPanel errorPanel;
	private JLabel errorLabel;

	/**
	 * Launch the application.
	 */
	public static void main(String[] args) {
		EventQueue.invokeLater(new Runnable() {
			public void run() {
				try {
					TextEditorGUI frame = new TextEditorGUI();
					frame.setVisible(true);
				} catch (Exception e) {
					e.printStackTrace();
				}
			}
		});
	}

	/**
	 * Create the frame.
	 */
	public TextEditorGUI() {
		setTitle("Text Editor");
		setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		setBounds(100, 100, 450, 300);
		contentPane = new JPanel();
		contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
		contentPane.setLayout(new BorderLayout(0, 0));
		setContentPane(contentPane);
		contentPane.add(getMainTextArea(), BorderLayout.CENTER);
		contentPane.add(getWestPanel(), BorderLayout.WEST);
		contentPane.add(getErrorPanel(), BorderLayout.SOUTH);
	}

	private JTextArea getMainTextArea() {
		if (mainTextArea == null) {
			mainTextArea = new JTextArea();
		}
		return mainTextArea;
	}
	private JPanel getWestPanel() {
		if (westPanel == null) {
			westPanel = new JPanel();
			westPanel.setPreferredSize(new Dimension(120, 10));
			westPanel.add(getLblNewLabel());
			westPanel.add(getFNameTextField());
			westPanel.add(getBtnLoad());
			westPanel.add(getBtnDelete());
			westPanel.add(getBtnSave());
			westPanel.add(getBtnExit());
		}
		return westPanel;
	}
	private JLabel getLblNewLabel() {
		if (lblNewLabel == null) {
			lblNewLabel = new JLabel("File name:");
		}
		return lblNewLabel;
	}
	private JTextField getFNameTextField() {
		if (fNameTextField == null) {
			fNameTextField = new JTextField();
			fNameTextField.setColumns(8);
		}
		return fNameTextField;
	}
	private JButton getBtnLoad() {
		if (btnLoad == null) {
			btnLoad = new JButton("Load");
			btnLoad.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					String fileName = fNameTextField.getText();
					try {
						String text = tDemo.readTextFromFile(fileName);
						mainTextArea.setText(text);
						errorLabel.setText("");
					} catch (IOException e1) {
						errorLabel.setText("An error occured while reading from file: " + e1.getMessage());
						e1.printStackTrace();
					}
					
				}
			});
			btnLoad.setPreferredSize(new Dimension(84, 29));
		}
		return btnLoad;
	}
	private JButton getBtnDelete() {
		if (btnDelete == null) {
			btnDelete = new JButton("Delete");
			btnDelete.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					mainTextArea.setText("");
				}
			});
		}
		return btnDelete;
	}
	private JButton getBtnSave() {
		if (btnSave == null) {
			btnSave = new JButton("Save");
			btnSave.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					String fileName = fNameTextField.getText();
					String text = mainTextArea.getText();
					try {
						tDemo.writeTextToFile(fileName, text);
						errorLabel.setText("");
					} catch (IOException e1) {
						errorLabel.setText("Error occurred while saving to file " + e1.getMessage());
						e1.printStackTrace();
					}
				}
			});
			btnSave.setPreferredSize(new Dimension(84, 29));
		}
		return btnSave;
	}
	private JButton getBtnExit() {
		if (btnExit == null) {
			btnExit = new JButton("Exit");
			btnExit.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					System.exit(0);
				}
			});
			btnExit.setPreferredSize(new Dimension(84, 29));
		}
		return btnExit;
	}
	private JPanel getErrorPanel() {
		if (errorPanel == null) {
			errorPanel = new JPanel();
			errorPanel.setPreferredSize(new Dimension(10, 29));
			errorPanel.add(getErrorLabel());
		}
		return errorPanel;
	}
	private JLabel getErrorLabel() {
		if (errorLabel == null) {
			errorLabel = new JLabel("");
		}
		return errorLabel;
	}
}
