package labs13.task1.gui;

import java.awt.BorderLayout;
import java.awt.EventQueue;

import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.JTextArea;

import java.awt.Dimension;

import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.JButton;

import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;
import java.io.IOException;

import labs13.task1.business_logic.TextDemo;

public class TextEditorGUI extends JFrame {

	private JPanel contentPane;
	private JTextArea textArea;
	private JPanel leftPanel;
	private JLabel lblFileName;
	private JTextField fileTextField;
	private JButton btnLoad;
	private JButton btnDelete;
	private JButton btnSave;
	private JButton btnExit;
	
	private TextDemo textDemo = new TextDemo();

	/**
	 * Launch the application.
	 */
	public static void main(String[] args) {
		EventQueue.invokeLater(new Runnable() {
			public void run() {
				try {
					TextEditorGUI frame = new TextEditorGUI();
					frame.setVisible(true);
				} catch (Exception e) {
					e.printStackTrace();
				}
			}
		});
	}

	/**
	 * Create the frame.
	 */
	public TextEditorGUI() {
		setTitle("Text Editor");
		setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		setBounds(100, 100, 450, 300);
		contentPane = new JPanel();
		contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
		contentPane.setLayout(new BorderLayout(0, 0));
		setContentPane(contentPane);
		contentPane.add(getTextArea(), BorderLayout.CENTER);
		contentPane.add(getLeftPanel(), BorderLayout.WEST);
	}

	private JTextArea getTextArea() {
		if (textArea == null) {
			textArea = new JTextArea();
		}
		return textArea;
	}
	private JPanel getLeftPanel() {
		if (leftPanel == null) {
			leftPanel = new JPanel();
			leftPanel.setPreferredSize(new Dimension(110, 10));
			leftPanel.add(getLblFileName());
			leftPanel.add(getFileTextField());
			leftPanel.add(getBtnLoad());
			leftPanel.add(getBtnDelete());
			leftPanel.add(getBtnSave());
			leftPanel.add(getBtnExit());
		}
		return leftPanel;
	}
	private JLabel getLblFileName() {
		if (lblFileName == null) {
			lblFileName = new JLabel("File name:");
		}
		return lblFileName;
	}
	private JTextField getFileTextField() {
		if (fileTextField == null) {
			fileTextField = new JTextField();
			fileTextField.setColumns(8);
		}
		return fileTextField;
	}
	private JButton getBtnLoad() {
		if (btnLoad == null) {
			btnLoad = new JButton("Load");
			btnLoad.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					String fName = fileTextField.getText();
					String text = textDemo.readTextFromFile(fName);
					if (text == null)
						textArea.setText("ERROR!");
					else textArea.setText(text);
				}
			});
			btnLoad.setPreferredSize(new Dimension(84, 29));
		}
		return btnLoad;
	}
	private JButton getBtnDelete() {
		if (btnDelete == null) {
			btnDelete = new JButton("Delete");
			btnDelete.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					textArea.setText("");
				}
			});
		}
		return btnDelete;
	}
	private JButton getBtnSave() {
		if (btnSave == null) {
			btnSave = new JButton("Save");
			btnSave.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					String fName = fileTextField.getText();
					String text = textArea.getText();
					try {
						textDemo.writeTextToFile(fName, text);
					} catch (IOException e1) {
						e1.printStackTrace();
						textArea.append("\n\n*** ERROR! *** \n" + e1.getMessage());
					}
				}
			});
			btnSave.setPreferredSize(new Dimension(84, 29));
		}
		return btnSave;
	}
	private JButton getBtnExit() {
		if (btnExit == null) {
			btnExit = new JButton("Exit");
			btnExit.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					System.exit(0);
				}
			});
			btnExit.setPreferredSize(new Dimension(84, 29));
		}
		return btnExit;
	}
}
