

import java.io.Serializable;

public class Region implements Serializable {

	private static final long serialVersionUID = 1L;

	private String name;
	
	private int birthRate;
	
	private int deathRate;
	
	private int migrationBalance;

	public String getName() {
		return name;
	}

	public void setName(String name) {
		if ( name == null )
			throw new DemographyException("Name of the region must not be null");
		
		int lettersCount = 0;
		for (int i = 0; i < name.length(); i++) {
			if ( Character.isLetter( name.charAt(i) ) ) {
				lettersCount++;
				if ( lettersCount == 2 ) {
					this.name = name;
					return;
				}
			}
		}
		if ( lettersCount < 2 )
			throw new DemographyException("Name of the region must contain at least 2 letters");
		
	}

	public int getBirthRate() {
		return birthRate;
	}

	public void setBirthRate(int birthRate) {
		if ( birthRate <= 0 )
			throw new DemographyException("Birth rate has to be a poistive number");
		this.birthRate = birthRate;
	}

	public int getDeathRate() {
		return deathRate;
	}

	public void setDeathRate(int deathRate) {
		if ( deathRate <= 0 )
			throw new DemographyException("Death rate has to be a poistive number");
		this.deathRate = deathRate;
	}

	public int getMigrationBalance() {
		return migrationBalance;
	}

	public void setMigrationBalance(int migrationBalance) {
		this.migrationBalance = migrationBalance;
	}
	
	public int computePopulationChange() {
		return getBirthRate() - getDeathRate() + getMigrationBalance();
	}
	
	@Override
	public String toString() {
		return "Region " + getName() + ", birth rate: " + getBirthRate() + "; death rate: " + getDeathRate() +
				"; migration balance: " + getMigrationBalance() +
				"; population change: " + computePopulationChange();
	}
	
	/**
	 * this method is not mentioned in the assignment; however, since
	 * in the RegionsGUI class we have to check if a region is in a list,
	 * we have to use the contains method and this method internally uses equals,
	 *  so, we have to override the equals method
	 */
	public boolean equals(Object obj) {
		if ( obj instanceof Region ) {
			
			Region r = (Region)obj;
			if ( r.getName().equals(this.getName()) )
				return true;
			else return false;
			
		} else return false;
	}
	
	
}
