/*
 * Decompiled with CFR 0.152.
 */
package BlockingQueue;

import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BlockingQueue<T> {
    private List<T> queue = new LinkedList<T>();
    private int size = 10;

    public BlockingQueue(int size) {
        this.size = size;
    }

    public synchronized void put(T item) {
        while (this.queue.size() == this.size) {
            try {
                this.wait();
            }
            catch (InterruptedException ex) {
                Logger.getLogger(BlockingQueue.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        if (this.queue.isEmpty()) {
            this.notifyAll();
        }
        this.queue.add(item);
    }

    public synchronized T take() {
        while (this.queue.isEmpty()) {
            try {
                this.wait();
            }
            catch (InterruptedException ex) {
                Logger.getLogger(BlockingQueue.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        if (this.queue.size() == this.size) {
            this.notifyAll();
        }
        return this.queue.remove(0);
    }
}

