/*
 * Decompiled with CFR 0.152.
 */
package threadpool;

import BlockingQueue.BlockingQueue;
import java.util.ArrayList;
import java.util.List;
import threadpool.PoolThread;

public class ThreadPool {
    private BlockingQueue taskQueue = null;
    private List<PoolThread> threads = new ArrayList<PoolThread>();
    private boolean isStopped = false;

    public ThreadPool(int noOfThreads, int maxNoOfTasks) {
        this.taskQueue = new BlockingQueue(maxNoOfTasks);
        for (int i = 0; i < noOfThreads; ++i) {
            this.threads.add(new PoolThread(this.taskQueue));
        }
        for (PoolThread thread : this.threads) {
            thread.start();
        }
    }

    public synchronized void execute(Runnable task) throws Exception {
        if (this.isStopped) {
            throw new IllegalStateException("ThreadPool is stopped");
        }
        this.taskQueue.put(task);
    }

    public synchronized void stop() {
        this.isStopped = true;
        for (PoolThread thread : this.threads) {
            thread.doStop();
        }
    }
}

